using gov.va.med.vbecs.Common;
using System;
using System.Collections.Generic;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingSpecimenAboRhModel
    /// </summary>
    public class PendingSpecimenAboRhModel : PendingTestModel, IPendingSpecimenTestModel
    {
        /// <summary>
        /// PatientSpecimenGuid
        /// </summary>
        public Guid PatientSpecimenGuid { get; set; }
        /// <summary>
        /// SpecimenUid
        /// </summary>
        public string SpecimenUid { get; set; }
        /// <summary>
        /// OrderedTest
        /// </summary>
        public OrderedTest OrderedTest { get; set; }
        /// <summary>
        /// SpecimenResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// SpecimenExpirationDate
        /// </summary>
        public DateTime? SpecimenExpirationDate { get; set; }
        /// <summary>
        /// CprsOrderNumber
        /// </summary>
        public string CprsOrderNumber { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                if (AboInterp != null &&
                    RhInterp != null)
                {
                    return AboInterp.TestResultId + " " + RhInterp.TestResultText;
                }

                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.AutomatedPatientABO;
            }
        }

        /// <summary>
        /// AntiA
        /// </summary>
        public PendingTestResultModel AntiA
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.AntiA,
                    TestType.AboRepeatAntiA,
                    TestType.AntiA_TAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AntiB
        /// </summary>
        public PendingTestResultModel AntiB
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.AntiB,
                    TestType.AboRepeatAntiB,
                    TestType.AntiB_TAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AntiAB
        /// </summary>
        public PendingTestResultModel AntiAB
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.AntiAB,
                    TestType.AboRepeatAntiAB,
                    TestType.AntiAB_TAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AntiAB
        /// </summary>
        public PendingTestResultModel A1Cells
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.PlasmaA1Cells,
                    TestType.AboRepeatPlasmaA1Cells,
                    TestType.A1Cells,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AntiAB
        /// </summary>
        public PendingTestResultModel BCells
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.PlasmaBCells,
                    TestType.AboRepeatPlasmaBCells,
                    TestType.BCells,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AntiD
        /// </summary>
        public PendingTestResultModel AntiD
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.AntiD,
                    TestType.AboRepeatAntiD,
                    TestType.AntiD_TAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// DControl
        /// </summary>
        public PendingTestResultModel DControl
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ControlD,
                    TestType.AboRepeatDControl,
                    TestType.DControl,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// AboInterp
        /// </summary>
        public PendingTestResultModel AboInterp
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.ABOInterp,
                    TestType.ABORepeat,
                    TestType.ABOInterpTAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// RhInterp
        /// </summary>
        public PendingTestResultModel RhInterp
        {
            get
            {
                var typeTypeList = new List<TestType>()
                {
                    TestType.RhInterp,
                    TestType.RhRepeat,
                    TestType.RhInterpTAS,
                };
                return GetPendingTestResult(typeTypeList, false);
            }
        }
        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate()
        {
            return BOL.TestValidation.ValidatePatientABORh(
                        AntiA == null ? string.Empty : AntiA.TestResultId,
                        AntiB == null ? string.Empty : AntiB.TestResultId,
                        AntiAB == null ? string.Empty : AntiAB.TestResultId,
                        A1Cells == null ? string.Empty : A1Cells.TestResultId,
                        BCells == null ? string.Empty : BCells.TestResultId,
                        AntiD == null ? string.Empty : AntiD.TestResultId,
                        DControl == null ? string.Empty : DControl.TestResultId,
                        AboInterp == null ? string.Empty : AboInterp.TestResultId,
                        RhInterp == null ? string.Empty : RhInterp.TestResultId,
                        OrderedTest,
                        SpecimenExpirationDate);
        }
    }
}



